% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guidance.R
\name{guide_SOAs_from_OA}
\alias{guide_SOAs_from_OA}
\title{Utility function for inspecting SOAs obtainable from an OA}
\usage{
guide_SOAs_from_OA(s, nOA, mOA, tOA, el = tOA, ...)
}
\arguments{
\item{s}{required; the unique number of levels of the columns of a given OA (need not be prime or prime power)}

\item{nOA}{required; the number of runs of the OA}

\item{mOA}{required; the number of columns of the OA}

\item{tOA}{required; the strength of the OA; strengths larger than 5 are
reduced to 5; \code{el} must not be larger than the
(reduced) strength, except for \code{tOA=2} with \code{el=3},
which is supported by the LLY algorithm}

\item{el}{the power to which \code{s} is to be taken, i.e. the SOA will have columns with \code{s^el} levels;
default: \code{tOA}.\cr
except for \code{tOA=2} and \code{el=3}, \code{el} can be chosen smaller than \code{tOA}, but not larger.
If \code{el} is smaller than \code{tOA}, \code{tOA} is internally reduced before working out the possibilities.}

\item{...}{currently unused}
}
\value{
The function returns a data frame, each row of which contains a possibility.
There is example code for constructing the SOA.
The code assumes that a given OA has the name \code{OA};
this can of course be modified by the user.
Further code details can also be adjusted by the user
(see the documentation of the respective functions).
}
\description{
Utility function for inspecting SOAs obtainable from an OA
}
\details{
The function provides the possible creation variants of an SOA
from a strength \code{tOA} OA with \code{mOA} \code{s}-level columns
in \code{nOA} runs,
for an SOA that has columns in \code{s^el} levels.
Note that the SOA may have \code{nOA} runs
or \code{s*nOA} runs, depending on the construction.
}
\examples{
## guide_SOAs_from_OA
## there is an OA(81, 3^10, 3) (L81.3.10 in package DoE.base)
## inspect what can be done with it:
guide_SOAs_from_OA(s=3, mOA=10, nOA=81, tOA=3)
## the output shows that a strength 3 OSOA
## with 4 columns of 27 levels each can be obtained in 81 runs
## and provides the necessary code (replace OA with L81.3.10)
##      optimize=FALSE reduces example run time
OSOAs_LiuLiu(L81.3.10, t=3, optimize=FALSE)
## or that an SOA with 9 non-orthogonal columns can be obtained
## in the same number of runs
SOAs(L81.3.10, t=3)
}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2023a)\cr
He and Tang (2013)\cr
He, Cheng and Tang (2018)\cr
Liu and Liu (2015)\cr
Li, Liu and Yang (2021)\cr
Shi and Tang (2020)\cr
Zhou and Tang (2019)\cr
}
\seealso{
\code{\link{guide_SOAs}}
}
\author{
Ulrike Groemping
}
\keyword{array}
