/*
 * Decompiled with CFR 0.152.
 */
package spotGui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;

public class fileIO {
    public static int writeStrListTo(ArrayList<String> myStrList, File myFile) {
        File pathOnly = new File(myFile.getParent());
        if (myFile.isDirectory()) {
            System.out.println("ERROR(writeStringListToFile): File was a Directory");
            return -1;
        }
        if (!pathOnly.exists()) {
            pathOnly.mkdirs();
            System.out.println("ROI path created: \"" + pathOnly.toString() + "\"");
        }
        try {
            FileWriter fw = new FileWriter(myFile);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(myStrList.get(0));
            int i = 1;
            while (i < myStrList.size()) {
                bw.write(String.valueOf(SystemUtils.LINE_SEPARATOR) + myStrList.get(i));
                ++i;
            }
            bw.close();
            System.out.println("File written: \"" + myFile.toString() + "\"");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.err.println("ERROR(writeStringListToFile): ArrayIndexOutOfBoundsException" + SystemUtils.LINE_SEPARATOR + "==> " + aioobe);
            return -2;
        }
        catch (IOException ioe) {
            System.err.println("ERROR(writeStringListToFile): IOException" + SystemUtils.LINE_SEPARATOR + "==> " + ioe);
            return -3;
        }
        return 0;
    }

    public static ArrayList<String> readToStrList(File myFile) {
        if (!myFile.exists()) {
            System.err.println("ERROR(readFileToString): File does not exist");
            return null;
        }
        if (!myFile.canRead()) {
            System.err.println("ERROR(readFileToString): Cannot read file");
            return null;
        }
        ArrayList<String> content = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(myFile);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                if (!line.matches("\\s*#.*") && !line.equals("")) {
                    content.add(line);
                }
                ++i;
            }
            br.close();
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            System.err.println("ERROR(readFileToString): ArrayIndexOutOfBoundsException" + SystemUtils.LINE_SEPARATOR + "==> " + aioobe);
            return null;
        }
        catch (IOException ioe) {
            System.err.println("ERROR(readFileToString): IOException" + SystemUtils.LINE_SEPARATOR + "==> " + ioe);
            return null;
        }
        return content;
    }

    public static void writeRSpot(String conf, String task, String tar, String log, String algpath) {
        try {
            File file = new File(tar);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.println("sink(\"" + log + "\",split=T)");
            out.println("require(SPOT)");
            if (!algpath.equals("")) {
                out.println("source(\"" + algpath + "\")");
            }
            out.println("mySpotConfig = spot(\"" + conf + "\",\"" + task + "\")");
            out.println("sink()");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static StringBuffer getTxt(String tar) {
        File file = new File(tar);
        StringBuffer cont = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    cont.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e0) {
                e0.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return cont;
    }

    public static String[] readFuncFromRscript(File myFile) {
        if (!myFile.exists()) {
            return null;
        }
        ArrayList<String> arrayListFullFile = fileIO.readToStrList(myFile);
        ArrayList<String> arrayListFunctions = new ArrayList<String>();
        String tmpLine = "";
        int i = 0;
        while (i < arrayListFullFile.size()) {
            tmpLine = arrayListFullFile.get(i).split("#")[0].replace(" ", "").replace("\t", "").replace("{", "");
            if (tmpLine.contains("=function")) {
                tmpLine = tmpLine.replace("=function", "<-function");
            }
            if (tmpLine.contains("<-function")) {
                arrayListFunctions.add(tmpLine.replace("<-", " <- "));
            }
            ++i;
        }
        return arrayListFunctions.toArray(new String[arrayListFunctions.size()]);
    }

    public static void writeTarFunc(File myFile, String fFormula, int dim, boolean noise, String noiseAmp) {
        String fName = "";
        try {
            if (myFile.getName().endsWith(".r")) {
                fName = myFile.getName().replace(".r", "");
            }
            if (myFile.getName().endsWith(".R")) {
                fName = myFile.getName().replace(".R", "");
            }
            PrintWriter out = new PrintWriter(new FileWriter(myFile));
            out.println(String.valueOf(fName) + " <- function(spotConfig){");
            out.println("\tf<-\"" + fName + "\"");
            out.println("\tn<-" + dim);
            if (noise) {
                out.println("\tnoise<-NULL");
            }
            out.println("\tif (spotConfig$spot.fileMode){");
            out.println("\t\twriteLines(paste(\"Loading design file data from::\",  spotConfig$io.desFileName), con=stderr());");
            out.println("\t\tdes <- read.table(spotConfig$io.desFileName, sep=\" \", header = TRUE);");
            out.println("\t}else{");
            out.println("\t\tdes <- spotConfig$alg.currentDesign;");
            out.println("\t}");
            if (noise) {
                out.println("\tnoise=" + noiseAmp + "  #Default noise value, will be overwritten if set in .apd");
            }
            out.println("\tif(file.exists(spotConfig$io.apdFileName)){source(spotConfig$io.apdFileName,local=TRUE)}");
            out.println("\tconfig<-nrow(des);");
            out.println("\tfor (k in 1:config){");
            out.println("\t\tfor (i in 1:des$REPEATS[k]){");
            int i = 1;
            while (i <= dim) {
                out.println("\t\t\tx" + i + " <- des$x" + i + "[k]");
                ++i;
            }
            out.println("\t\t\tconf <- des$CONFIG[k]");
            out.println("\t\t\tstep <- des$STEP[k]");
            out.println("\t\t\tseed <- des$SEED[k]+i-1");
            out.println("\t\t\tprint(c(\"Config:\",k ,\" Repeat:\",i))");
            out.println("\t\t\ty <- " + fFormula + "+" + noiseAmp + "*rnorm(1)");
            out.println("\t\t\tprint(y)");
            out.println("\t\t\tres <- NULL");
            out.println("\t\t\tres <- list(Y=y,");
            i = 1;
            while (i <= dim) {
                out.println("\t\t\t\t\tx" + i + "=x" + i + ",");
                ++i;
            }
            out.println("\t\t\t\t\tFunction=f,");
            out.println("\t\t\t\t\tDIM=n,");
            out.println("\t\t\t\t\tSTEP=step,");
            out.println("\t\t\t\t\tSEED=seed,");
            out.println("\t\t\t\t\tCONFIG=conf");
            out.println("\t\t\t)");
            out.println("\t\t\tres <-data.frame(res)");
            out.println("\t\t\tif (spotConfig$spot.fileMode){");
            out.println("\t\t\t\tcolNames = TRUE");
            out.println("\t\t\t\tif (file.exists(spotConfig$io.resFileName)){");
            out.println("\t\t\t\t\tcolNames = FALSE");
            out.println("\t\t\t\t}");
            out.println("\t\t\t\twrite.table(res");
            out.println("\t\t\t\t\t\t, file = spotConfig$io.resFileName");
            out.println("\t\t\t\t\t\t, row.names = FALSE");
            out.println("\t\t\t\t\t\t, col.names = colNames");
            out.println("\t\t\t\t\t\t, sep = \" \"");
            out.println("\t\t\t\t\t\t, append = !colNames");
            out.println("\t\t\t\t\t\t, quote = FALSE");
            out.println("\t\t\t\t);");
            out.println("\t\t\t}");
            out.println("\t\t\tspotConfig$alg.currentResult=rbind(spotConfig$alg.currentResult,res);");
            out.println("\t\t}");
            out.println("\t}");
            out.println("\treturn(spotConfig)");
            out.println("}");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

