\name{spotGlgEvalN}
\alias{spotGlgEvalN}
\title{Gaussian Landscape Evaluation (multiple)}
\usage{
  spotGlgEvalN(x, glglist)
}
\arguments{
  \item{x}{matrix of sample sites, containing one point in
  each row.}

  \item{glglist}{list of lists (one for each landscape) of
  values defining the Gaussian Landscape, created by
  \code{spotGlgInit}.}
}
\value{
  returns a list, with the following items:\cr \code{value}
  vector of values from each landscape. \code{components}
  value of each component (will be NA)
}
\description{
  This function is based on the Gaussian Landscape
  Generator by Bo Yuan and Marcus Gallagher. It randomly
  evaluates one or several points in several Gaussian
  Landscapes at once, as created by \code{spotGlgInitN}.
}
\references{
  B. Yuan and M. Gallagher (2003) "On Building a Principled
  Framework for Evaluating and Testing Evolutionary
  Algorithms: A Continuous Landscape Generator". In
  Proceedings of the 2003 Congress on Evolutionary
  Computation, IEEE, pp. 451-458, Canberra, Australia.
}
\seealso{
  \code{\link{spotGlgCreateN}}, \code{\link{spotGlgInitN}},
  \code{\link{spotGlgEval}} , \code{\link{spotGlgEvalRot}}
}

