% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotPredictDace.R
\name{daceFixTheta}
\alias{daceFixTheta}
\title{Fix model parameters}
\usage{
daceFixTheta(m, bestTheta, nugget, corr)
}
\arguments{
\item{m}{dimension (length) of each point}

\item{bestTheta}{the theta value found during MLE}

\item{nugget}{Value for nugget. Default is -1, which means the nugget was be optimized during MLE. In this case, it is part of bestTheta. Otherwise, \code{nugget} is appended to the theta vector. This is only relevant for correlation functions that use a nugget (\code{\link{corrnoisygauss}},\code{\link{corrnoisykriging}} )}

\item{corr}{The choice of correlation function (which defines the length and values of theta and bounds): \code{\link{corrnoisykriging}} (default), \code{\link{corrkriging}}, \code{\link{corrnoisygauss}}, \code{\link{corrgauss}}, \code{\link{correxp}}, \code{\link{correxpg}}, \code{\link{corrlin}}, \code{\link{corrcubic}},\code{\link{corrspherical}},\code{\link{corrspline}}. Can also be user supplied (if in the right form).}
}
\value{
returns a list:
	\code{thetaConv} the fixed theta vector (all model parameters)
	\code{theta} vector of activity parameters theta
	\code{p} vector of exponents p(NULL if not used in correlation function)
	\code{lambda} nugget value lambda (NULL if not used in correlation function)
}
\description{
This function fixes theta (model parameter vector) after optimization. That is, if a value was optimized on a logarithmic scale: \code{theta=10^theta}.
The result depends on dimensionality of the problem, the nugget value and the choice of correlation function.
}
\seealso{
\code{\link{daceBuilder}}
}
\keyword{internal}

