% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotPredictEnsembleMultiRankWeighted.R
\name{spotEnsembleMultiRankWeighted}
\alias{spotEnsembleMultiRankWeighted}
\title{spotEnsembleMultiRankWeighted}
\usage{
spotEnsembleMultiRankWeighted(rawB, mergedB, design, spotConfig, fit = NULL)
}
\arguments{
\item{rawB}{unmerged data}

\item{mergedB}{merged data}

\item{design}{new design points which should be predicted}

\item{spotConfig}{global list of all options, needed to provide data for calling functions}

\item{fit}{should always be NULL. Evaluation of existing fits is not implemented for this ensemble.}
}
\value{
returns the list \code{spotConfig}
}
\description{
Alternating Recommendation of Candidate Points \cr
This "multi ensemble" uses the same ranking approach as \code{\link{spotEnsembleMultiRank}}. Additionally, the ranks
are weighted. To determine an appropriate weight, the models feedback (e.g. error measure) is employed.\cr
Relevant configuration parameters of this ensemble are: \cr
The function to calculate feedback (e.g. the error) of the models, default is \code{spotConfig$seq.ensemble.feed.func<-spotFeedback.error.full} \cr
The number of designs cut off for leave-one-out validation should always be zero for this ensemble, i.e \code{spotConfig$seq.ensemble.cut.num <- 0}
}
\details{
This is a "multi ensemble", meaning that in every sequential step all models in the ensemble are trained and evaluated.
The target is to actively combine all models responses, to get the best estimate on which candidate points are optimal.\cr
The models used are specified in the \code{spotConfig} list, for instance:\cr
\code{spotConfig$seq.ensemble.predictors = c(spotPredictRandomForest, spotPredictEarth, spotPredictForrester, spotPredictDace)}\cr
To specify the settings of each individual model, set:\cr
\code{seq.ensemble.settings = list(list(setting=1),list(setting=2),list(setting=3),list(setting=4))}\cr
Any parameters set in each of the corresponding lists (here: 4 individual lists) will overwrite settings in the main \code{spotConfig} list,
when the concerned model function is called.
}
\references{
- M. Friese, M. Zaefferer, T. Bartz-Beielstein, O. Flasch, P. Koch, W. Konen, and
B. Naujoks. Ensemble based optimization and tuning algorithms. In F. Hoffmann
and E. Huellermeier, editors, Proceedings 21. Workshop Computational Intelligence,
p. 119-134. Universitaetsverlag Karlsruhe, 2011.
}

