% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotGaussianLandscapeGenerator.R
\name{spotGlgCore}
\alias{spotGlgCore}
\title{Gaussian Landscape Core function}
\usage{
spotGlgCore(dimension = 2, nGaussian = 10, lower = rep(0, dimension),
  upper = rep(1, dimension), globalvalue = 1, ratio = 0.8)
}
\arguments{
\item{dimension}{dimensionality of the landscapes input space. Default is 2.}

\item{nGaussian}{number of Gaussian components in the landscape. Default is 10.}

\item{lower}{lower boundary of the landscape, defaults to \code{rep(0,dimension)}.}

\item{upper}{upper boundary of the landscape, defaults to \code{rep(1,dimension)}.}

\item{globalvalue}{the global maximum value, i.e. the maximum of the Gaussian component with the largest value. Default is 1.}

\item{ratio}{maximum ratio of the local maxima, local optima are randomly generated within \code{[0,globalvalue*ratio]}. Has to be larger than 0 and smaller than 1. Defaults to 0.8.}
}
\description{
Core gaussian landscape function. Should not be called directly, as it does not contain proper seed handling.
}
\author{
Based on original Matlab code by Bo Yuan, ported to R and further adaptions by Martin Zaefferer
}
\keyword{internal}

