% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPredictHelpFunctions.R
\name{spotModel.train}
\alias{spotModel.train}
\title{Model Training Interface
 
This function is used to interface the \code{spotPredict*} (e.g.: \code{\link{spotPredictRandomForest}}) functions.
It serves as a simple interface to train surrogate models, as need by the user.}
\usage{
spotModel.train(X, y, method = "spotPredictTree", settings = NULL)
}
\arguments{
\item{X}{Matrix of sample locations. Rows for points, columns for variables.}

\item{y}{Observations at sample locations (vector)}

\item{method}{which model function should be used specified as a string, e.g., "spotPredictRandomForest", "spotPredictLm", "spotPredictForrester". Most other "spotPredict*" functions provided by SPOT should work.}

\item{settings}{additional settings, as used by the corresponding \code{spotPredict*} function. NULL means default model settings are used.}
}
\value{
the list of settings, including the model fit. This list can be employed as the "fit" parameter in \code{\link{spotModel.predict}}.
}
\description{
Model Training Interface
 
This function is used to interface the \code{spotPredict*} (e.g.: \code{\link{spotPredictRandomForest}}) functions.
It serves as a simple interface to train surrogate models, as need by the user.
}
\examples{
## simple test function
sphereFunction <- function(X) rowSums(X^2)
## sample locations
Xtrain <- matrix(runif(20),,2)
## evaluate on test function
y <- sphereFunction(Xtrain) 
## train model
model <- spotModel.train(Xtrain,y,"spotPredictLm")
## print model fit
print(model$seq.modelFit)
}
\seealso{
instead of building a fit to be evaluated by \code{\link{spotModel.predict}} the \code{\link{spotModel.func}} function
directly produces functions, which can be evaluated with new data.
}

