% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotCreateDesignLhd.R
\name{spotNormDesign}
\alias{spotNormDesign}
\title{spotNormDesign}
\usage{
spotNormDesign(dim, size, calcMinDistance = FALSE, nested = NULL,
  ineq_constr = NULL)
}
\arguments{
\item{dim}{number, dimension of the problem (will be no. of columns of the result matrix)}

\item{size}{number of points with that dimension needed. (will be no. of rows of the result matrix).}

\item{calcMinDistance}{Boolean to indicate whether a minimal distance should be calculated.}

\item{nested}{nested design to be considered during distance calculation.}

\item{ineq_constr}{inequality constraint, smaller zero for infeasible points. Used to replace infeasible points with random points. Has to evaluate points in interval [0;1].}
}
\value{
list \code{L}  \cr
- \code{L} consists of a matrix and nd (if required) a minimal distance
}
\description{
Produces a normalized design and calculates the minimal distance 
if required.
A design  is a matrix with \code{dim} columns and \code{size} rows.
Distance can be calculated with respect to a fixed, nested design.
}
\author{
Christian Lasarczyk, adapted for nested designs by Martin Zaefferer
}
\seealso{
This function is used as a basis for \code{\link{spotCreateDesignLhd}}.
}
\keyword{internal}

