% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotSurf.R
\name{spotSurfContour}
\alias{spotSurfContour}
\title{spotSurfContour}
\usage{
spotSurfContour(f = function(x) {     rowSums(x^2) }, lo = c(0, 0),
  up = c(1, 1), s = 100, xlab = "x1", ylab = "x2",
  color.palette = terrain.colors, title = " ", levels = NULL, points1,
  points2, pch1 = 20, pch2 = 8, lwd1 = 1, lwd2 = 1, cex1 = 1,
  cex2 = 1, col1 = "black", col2 = "black", ...)
}
\arguments{
\item{f}{function to be plotted. The function should either be able to take two vectors or one matrix specifying sample locations. i.e. \code{y=f(X)} or \code{y=f(x2,x1)} where Z is a two column matrix containing the sample locations \code{x1} and \code{x2}.}

\item{lo}{lower boundary for x1 and x2 (defaults to \code{c(0,0)}).}

\item{up}{upper boundary (defaults to \code{c(1,1)}).}

\item{s}{number of samples along each dimension. e.g. \code{f} will be evaluated \code{s^2} times.}

\item{xlab}{lable of first axis}

\item{ylab}{lable of second axis}

\item{color.palette}{colors used, default is \code{terrain.color}}

\item{title}{title of the plot}

\item{levels}{number of levels for the plotted function value. Will be set automatically with default NULL.}

\item{points1}{can be omitted, but if given the points in this matrix are added to the plot in form of dots}

\item{points2}{can be omitted, but if given the points in this matrix are added to the plot in form of crosses}

\item{pch1}{pch (symbol) setting for points1 (default: 20)}

\item{pch2}{pch (symbol) setting for points2 (default: 8)}

\item{lwd1}{line width for points1 (default: 1)}

\item{lwd2}{line width for points2 (default: 1)}

\item{cex1}{cex for points1 (default: 1)}

\item{cex2}{cex for points2 (default: 1)}

\item{col1}{color for points1 (default: "black")}

\item{col2}{color for points2 (default: "black")}

\item{...}{additional parameters passed to \code{f}}
}
\description{
Simple surface plot, using the filled.contour function.
}
\examples{
spotSurfContour(function(x){apply(x,1,spotBraninFunction)},c(-5,0),c(10,15))

}
\seealso{
\code{\link{spotSurf3d}}
}

