% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funSring.R
\name{init_ring}
\alias{init_ring}
\title{init_ring}
\usage{
init_ring(params)
}
\arguments{
\item{params}{list of 
\describe{
    \item{\code{randomSeed}}{random seed}
    \item{\code{nStates}}{number of S-Ring states}
    \item{\code{nElevators}}{number of elevators}
    \item{\code{probNewCustomer}}{probability pf a customer arrival}
    \item{\code{counter}}{Counter: number of waiting customers}
    \item{\code{sElevator}}{Vector representing elevators (s)}
     \item{\code{sCustomer}}{Vector representing customers (c)}
    \item{\code{currentState}}{Current state that is calculated}
    \item{\code{nextState}}{Next state that is calculated}
    \item{\code{nWeights}}{Number of weights for the perceptron (= 2 * nStates)}
    }}
}
\value{
list (params) of 
\describe{
	\item{\code{randomSeed}}{random seed}
	\item{\code{nStates}}{number of S-Ring states}
	\item{\code{nElevators}}{number of elevators}
	\item{\code{probNewCustomer}}{probability pf a customer arrival}
	\item{\code{counter}}{Counter: number of waiting customers}
	\item{\code{sElevator}}{Vector representing elevators (s)}
 	\item{\code{sCustomer}}{Vector representing customers (c)}
	\item{\code{currentState}}{Current state that is calculated}
	\item{\code{nextState}}{Next state that is calculated}
	\item{\code{nWeights}}{Number of weights for the perceptron (= 2 * nStates)}
    }
}
\description{
Initialize ring parameters: generate arrival probabilities for S-Ring.
 - set beginning states to 0 and initialize random customer states and nElevators
 - nStates = (number of floors * 2) - 2. For example for 4 floors, 
              its 6 states because the upper and lower state have only 
              one direction and all other have 2 (UP and DOWN)
}
\examples{

params <-list(sElevator=NULL,
  sCustomer=NULL,
  currentState=NULL,
  nextState=NULL,
  counter=NULL,
  nStates=12,
  nElevators=2,
  probNewCustomer=0.1,
  weightsPerceptron=rep(0.1, 24),
  nWeights=NULL,
  nIterations=100,
  randomSeed=1234)
  
init_ring(params)
 
}
