% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNAs.R
\name{handleNAsKrigingWorst}
\alias{handleNAsKrigingWorst}
\title{handleNAsKrigingWorst}
\usage{
handleNAsKrigingWorst(
  x,
  y,
  penaltyImputation = 3,
  imputeCriteriaFuns = list(is.na, is.infinite, is.nan)
)
}
\arguments{
\item{x}{The x values from which y was calculated}

\item{y}{The vector of numerics from which the NAs should be removed}

\item{penaltyImputation}{multiplier for sPredicted (penalty term). Default: \code{3}.}

\item{imputeCriteriaFuns}{\code{list} criteria functions specified via
\code{imputeCriteriaFuns} in \code{\link{spotControl}}. Default:
\code{list(is.na, is.infinite, is.nan)}.}
}
\value{
y The imputed vector w/o \code{NA} and w/o \code{Inf} values.
}
\description{
Remove NAs from a vector by replacing them with a penalized
Kriging-based expectation
}
\examples{
imputeCriteriaFuns <- list(is.na, is.infinite, is.nan)
x <- matrix(runif(20), ncol = 2)
y <- funSphere(x)
y[3] <- NA
y[5] <- Inf
plot(y, type="b")
print(y)
y1 <- handleNAsKrigingWorst(x=x, y=y, imputeCriteriaFuns=imputeCriteriaFuns)
print(y1)
points(3, y1[3], type="b", col="red")
points(5, y1[5], type="b", col="red")
}
