% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEstimator.R
\name{plotEstimator}
\alias{plotEstimator}
\title{plot SPQR estimators}
\usage{
plotEstimator(object, X, ...)
}
\arguments{
\item{object}{An object of class \code{"SPQR"}}

\item{X}{A row vector indicating covariate values for which the conditional PDF/CDF/QF is computed and plotted.}

\item{...}{
  Arguments passed on to \code{\link[=predict.SPQR]{predict.SPQR}}
  \describe{
    \item{\code{nY}}{An integer number indicating length of grid when \code{Y} is not specified. Default: 101.}
    \item{\code{type}}{The function to be predicted; \code{"PDF"}: probability density function,
\code{"CDF"}: cumulative distribution function, and \code{"QF"}: the quantile function (default).}
    \item{\code{tau}}{The grid of quantiles for which the quantile function is computed. Default: \code{seq(0.1,0.9,0.1)}.}
    \item{\code{ci.level}}{The credible level for computing the pointwise credible intervals. The
default is 0 indicating no credible intervals should be computed.}
    \item{\code{getAll}}{If \code{TRUE}, extracts all posterior samples of the prediction. Default: \code{FALSE}.}
  }}
}
\value{
A \code{ggplot} object.
}
\description{
Computes and plots the estimated PDF/CDF/QF curves.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)


## plot estimated PDF
plotEstimator(fit, type = "PDF", X = 0)
}
}
