% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.SPQR.R
\name{print.SPQR}
\alias{print.SPQR}
\title{print method for class \code{SPQR}}
\usage{
\method{print}{SPQR}(x, ...)
}
\arguments{
\item{x}{An object of class \code{SPQR}}

\item{...}{
  Arguments passed on to \code{\link[=print.summary.SPQR]{print.summary.SPQR}}
  \describe{
    \item{\code{showModel}}{If \code{TRUE}, prints the detailed NN architecture by layer.}
  }}
}
\value{
No return value, called for side effects.
}
\description{
Summarizes and print the output produced by SPQR() in an organized way.
}
\details{
This is equivalent to the function call \code{print.summary.SPQR(summary.SPQR(object), ...)}.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)
print(fit, showModel = TRUE)
}
}
