% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms.image_methods.R
\docType{methods}
\name{binOtsu,ms.image-method}
\alias{binOtsu,ms.image-method}
\alias{binOtsu}
\title{Binarize MS image using Otsu's thresholding.}
\usage{
\S4method{binOtsu}{ms.image}(object)
}
\arguments{
\item{object}{\link{ms.image-class} object. See \link{msImage}.}
}
\value{
\link{ms.image-class} object with binary intensities.
}
\description{
Binarize MS image using Otsu's thresholding.
}
\examples{
## Load package
library("SPUTNIK")

## Create ms.image-class object
msIm <- msImage(values = matrix(rnorm(200), 40, 50), name = "test", scale = TRUE)

## Generate binary image
binIm <- binOtsu(msIm)
}
