% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportKrona.R
\name{exportKrona}
\alias{exportKrona}
\title{Export the taxonomy of a SQM object into a Krona Chart}
\usage{
exportKrona(SQM, output_name = NA)
}
\arguments{
\item{SQM}{A SQM or SQMlite object.}

\item{output_name}{character. Name of the output file containing the Krona charts in html format (default \code{"<project_name>.krona.html")}.}
}
\value{
No return value, but a krona chart is produced in the current working directory.
}
\description{
Generate a krona chart containing the full taxonomy from a SQM object.
}
\details{
Original code was kindly provided by Giuseppe D'Auria (dauria_giu@gva.es).
}
\examples{
\donttest{
data(Hadza)
# Check that kronatools is present.
ecode = system('ktImportText', ignore.stdout = TRUE, ignore.stderr = TRUE)
# If so, run.
if(ecode==0) { exportKrona(Hadza) }
}
}
\seealso{
\code{\link{plotTaxonomy}} for plotting the most abundant taxa of a SQM object.
}
