#' Baby births in one day at one hospital
#'
#' Details of the births on one day from a Brisbane hospital.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 44 rows (one per birth) and 3 columns:
#' \describe{
#'   \item{Gender}{The gender of the child; one of \code{Female} or \code{Male}}
#'   \item{Weight}{The weight of the baby, in kg}
#'   \item{Mins.Since.Midnight}{the time of birth, in minutes since midnight}
#' }
#' @source 
#' Steele, S. 1997. Babies by the Dozen for Christmas: 24-Hour Baby Boom. 
#' \emph{The Sunday Mail}, 7.
#' 
#' Dunn, Peter K. 1999. A Simple Dataset for Demonstrating 
#' Common Distributions. 
#' \emph{Journal of Statistics Education}, \bold{7} (3).
#' 
#' @usage 
#' data(BabyBoom)
#' 
#' @examples
#' plot(Weight ~ factor(Gender), data = BabyBoom)

"BabyBoom"
