% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddLeadingZeros.R
\name{AddLeadingZeros}
\alias{AddLeadingZeros}
\title{Add leading zeros to numbers while preserving other text}
\usage{
AddLeadingZeros(
  codes,
  places,
  warningText = NULL,
  viaFactor = TRUE,
  nWarning = 6,
  removeLeadingTrailingWhitespace = TRUE
)
}
\arguments{
\item{codes}{Character vector}

\item{places}{Number of places for positive numbers. Minus sign is extra}

\item{warningText}{When non-NULL, warning will be produced}

\item{viaFactor}{When TRUE, the algorithm uses factor coding internally.}

\item{nWarning}{Number of elements to be written before ... in warnings.}

\item{removeLeadingTrailingWhitespace}{Remove leading and trailing whitespace}
}
\value{
Character vector
}
\description{
This function is created to fix problems caused by a serious bug in Excel.
Editing csv files in that program causes leading zeros to disappear.
}
\examples{
AddLeadingZeros(c("1", "ABC", "12345", " 23", "-8", "45 ", " -9", " Agent ", "007", 
                  "7 James Bond "), 10)
AddLeadingZeros(c("1", "ABC", "12345", " 23", "-8", "45 ", " -9", " Agent ", "007", 
                  "7 James Bond "), 4)
AddLeadingZeros(c("1", "ABC", "12345", " 23", "-8", "45 ", " -9", " Agent ", "007", 
                  "7 James Bond "), 4, removeLeadingTrailingWhitespace = FALSE)
AddLeadingZeros(c("1", "ABC", "12345", " 23", "-8", "45 ", " -9", " Agent ", "007", 
                  "7 James Bond "), 4, warningText = "string changes")
AddLeadingZeros(c("1", "ABC", "12345", " 23", "-8", "45 ", " -9", " Agent ", "007", 
                  "7 James Bond "), 4, warningText = "", nWarning = 2)
}
\author{
Øyvind Langsrud
}
