% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CheckInput.r
\name{CheckInput}
\alias{CheckInput}
\alias{check_input}
\title{Checking function inputs}
\usage{
CheckInput(
  x,
  alt = NULL,
  min = NULL,
  max = NULL,
  type = "character",
  data = NULL,
  okSeveral = FALSE,
  okNULL = FALSE,
  okNA = FALSE,
  okDuplicates = is.null(alt) & !(type \%in\% c("varName", "varNr", "varNrName"))
)

check_input(
  x,
  alt = NULL,
  min = NULL,
  max = NULL,
  type = "character",
  data = NULL,
  okSeveral = FALSE,
  okNULL = FALSE,
  okNA = FALSE,
  okDuplicates = is.null(alt) & !(type \%in\% c("varName", "varNr", "varNrName"))
)
}
\arguments{
\item{x}{Input vector to be checked}

\item{alt}{\code{NULL} or vector of allowed values}

\item{min}{\code{NULL} or minimum value (when \code{type} is numeric or integer)}

\item{max}{\code{NULL} or maximum value (when \code{type} is numeric or integer)}

\item{type}{One of: \code{"character"}, \code{"numeric"}, \code{"integer"}, \code{"logical"}, \code{"varName"}, \code{"varNr"}, \code{"varNrName"}.
numeric/integer is not checked against exact class, but whether the value fit into the class.
Also see data below.}

\item{data}{A data frame or matrix. When above type is \code{varNames}, \code{x} is checked against \code{colnames(data)}.
When type is \code{varNr}, \code{x} is checked against column numbers.
When type is \code{varNrName}, \code{x} can be either column numbers or column names.}

\item{okSeveral}{When \code{TRUE}, \code{length(x)>1} is allowed}

\item{okNULL}{When \code{TRUE}, \code{NULL} is allowed}

\item{okNA}{When \code{TRUE}, \code{NA} is allowed}

\item{okDuplicates}{When \code{TRUE}, duplicated values are allowed.
Default is \code{TRUE} if \code{alt} is \code{NULL} and if \code{type} does not refer to column(s) of \code{data}.}
}
\description{
An input vector (of length one unless \code{okSeveral} is \code{TRUE}) is checked.
}
\details{
\code{x} is checked according to the other input parameters.
When \code{x} is wrong an error is produced with appropriate text.

\emph{The function was originally created in 2016 and has been included in
internal packages at Statistics Norway (SSB). Due to its widespread use,
it was beneficial to include it in this CRAN package.}
}
\note{
\code{check_input} and \code{CheckInput} are identical
}
\examples{
a <- c("no", "yes")
b <- c(3.14, 4, 5)
z <- data.frame(A = a, B = b[1:2], C = TRUE)

# Lines causing error are embedded in 'try'

try(CheckInput(a, type = "character"))
CheckInput(a, type = "character", alt = c("no", "yes", "dontknow"), okSeveral = TRUE)
try(CheckInput("yesno", type = "character", alt = c("no", "yes", "dontknow")))
CheckInput(a[1], type = "character", alt = c("no", "yes", "dontknow"))

try(CheckInput(b, type = "integer", max = 100, okSeveral = TRUE))
try(CheckInput(b, type = "numeric", min = 4, okSeveral = TRUE))
CheckInput(b, type = "numeric", max = 100, okSeveral = TRUE)
try(CheckInput(b, type = "numeric", alt = 1:10, okSeveral = TRUE))
CheckInput(b[2], type = "numeric", alt = 1:10)

try(CheckInput("TRUE", type = "logical"))
CheckInput(TRUE, type = "logical")

try(CheckInput("A", type = "varName"))
CheckInput("A", type = "varName", data = z)
CheckInput(c("A", "B"), type = "varNrName", data = z, okSeveral = TRUE)
try(CheckInput("ABC", type = "varNrName", data = z))
try(CheckInput(5, type = "varNrName", data = z))
CheckInput(3, type = "varNr", data = z)
CheckInput(2:3, type = "varNr", data = z, okSeveral = TRUE)
}
\author{
Øyvind Langsrud
}
