% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSfitNonNeg.R
\encoding{UTF8}
\name{LSfitNonNeg}
\alias{LSfitNonNeg}
\title{Non-negative regression fits with a sparse overparameterized model matrix}
\usage{
LSfitNonNeg(x, z, limit = 1e-10, viaQR = FALSE, printInc = TRUE)
}
\arguments{
\item{x}{A matrix}

\item{z}{A single column matrix}

\item{limit}{Lower limit for non-zero fits. Set to \code{NULL} or \code{-Inf} to avoid the non-zero restriction.}

\item{viaQR}{Least squares fits obtained using \code{\link{qr}} when \code{TRUE}.}

\item{printInc}{Printing "..." to console when \code{TRUE}.}
}
\value{
A fitted version of \code{z}
}
\description{
Assuming  \code{z = t(x) \%*\% y  + noise}, a non-negatively modified least squares estimate of \code{t(x) \%*\% y} is made.
}
\details{
The problem is first reduced by elimination some rows of \code{x}  (elements of \code{y}) using \code{\link{GaussIndependent}}.
Thereafter least squares fits are obtained using \code{\link{solve}} or \code{\link{qr}}.
Possible negative fits will be forced to zero in the next estimation iteration(s).
}
\examples{
set.seed(123)
data2 <- SSBtoolsData("z2")
x <- ModelMatrix(data2, formula = ~fylke + kostragr * hovedint - 1)
z <- Matrix::t(x) \%*\% data2$ant + rnorm(ncol(x), sd = 3)
LSfitNonNeg(x, z)
LSfitNonNeg(x, z, limit = NULL)

\dontrun{
mf <- ~region*mnd + hovedint*mnd + fylke*hovedint*mnd + kostragr*hovedint*mnd
data4 <- SSBtoolsData("sosialFiktiv")
x <- ModelMatrix(data4, formula = mf)
z <- Matrix::t(x) \%*\% data4$ant + rnorm(ncol(x), sd = 3)
zFit <- LSfitNonNeg(x, z)
}
}
\author{
Øyvind Langsrud
}
