% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.SSN2}
\alias{logLik.SSN2}
\alias{logLik.ssn_lm}
\alias{logLik.ssn_glm}
\title{Extract log-likelihood}
\usage{
\method{logLik}{ssn_lm}(object, ...)

\method{logLik}{ssn_glm}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The log-likelihood.
}
\description{
Find the log-likelihood of a fitted model.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
logLik(ssn_mod)
}
