% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssn_put_data.R
\name{ssn_put_data}
\alias{ssn_put_data}
\title{Put an sf data.frame in an SSN object}
\usage{
ssn_put_data(data, x, name = "obs", resize_data = FALSE)
}
\arguments{
\item{data}{sf data.frame with point geometry.}

\item{x}{An object of class SSN, ssn_lm, or ssn_glm.}

\item{name}{the internal name of the data set in the object
\code{x}. For observed data, this will always be "obs", the
default.}

\item{resize_data}{Logical. Indicates whether sf_df can have a
different number of features than the current data.frame in the
object. Default is FALSE.}
}
\value{
Returns an object of the same class as x, which contains
the sf data.frame sf_data.
}
\description{
The \command{ssn_put_data} function puts an sf
data.frame representing observation or prediction
data into an SSN, ssn_lm, or ssn_glm object.
}
\details{
The internal \code{name} for observed data in objects of
class \code{SSN}, \code{ssn_lm}, and \code{ssn_glm} is "obs" and it is the
default. If another \code{name} is specified, it must represent a
prediction dataset in the object. For \code{SSN} objects,
these names are obtained using the call \code{names(x$preds)}. For
all other object classes, the names are obtained using the call
names(x$ssn.object$preds).

The \code{resize_sf_data} argument specifies whether sf_data can have a
different number of features (i.e., rows) than the sf data.frame
it is replacing. Care should be taken when resize_df is set to
TRUE, especially if the new sf_data has more features than the
existing sf data.frame. In these cases, the user is responsible
for ensuring that the additional features have the correct
spatial, topological, and attribute data to accurately represent
spatial relationships in the SSN object.
}
\examples{
data(mf04p)
## Extract observation data.frame from SSN object
obs.df <- ssn_get_data(mf04p)
## Create a new column for summer mean temperature and set Value in
obs.df$Value <- obs.df$Summer_mn
obs.df$Value[1] <- NA

## Put the modified sf data.frame into the SSN object
mf04p <- ssn_put_data(obs.df, mf04p)
head(ssn_get_data(mf04p)[, c("Summer_mn", "Value")])
}
\seealso{
\code{\link[=ssn_get_data]{ssn_get_data()}}
}
