#' Ssrat, a Program for Two-dimensional Sociometric Status Determination with
#' Rating Scales
#' 
#' SSrat is a collection of functions for two-dimensional sociometric status
#' determination with rating scales. The theory underlying the program is
#' described in Maassen, Akkermans and Van der Linden (1996). A discussion of
#' the advantages of using ratings for sociometric status classification is
#' given by Maassen, Van der Linden and Akkermans (1997). The basics of the
#' algorithms are described in Maassen and Landsheer (1998). For each person
#' assessed, SSRAT computes probability distributions of the total scores for
#' `sympathy' (S), `antipathy' (A), `social preference' (P) and `social impact'
#' (I), and applies criteria for sociometric status categorization as described
#' in Maassen et al. (1996).
#' 
#' \tabular{ll}{ Package: \tab SSrat\cr Type: \tab Package\cr Version: \tab
#' 1.0\cr Date: \tab 2014-09-09\cr License: \tab GPL-2\cr }
#' 
#' @name SSrat
#' @aliases SSrat-package SSrat ssrat
#' @docType package
#' @author Gerard Maassen and Hans Landsheer\cr Maintainer: Hans Landsheer
#' @seealso For plotting see also package \code{sna}\cr Also readratdatafixed
#' uses packages \code{plyr}
#' @references Maassen, G.H., Akkermans, W. and Van der Linden, J.L. (1996).
#' Two-dimensional Sociometric Status Determination with Rating Scales; a
#' Probability and a Standard Score Method. Small Group Research, 27, 56-78.\cr
#' Maassen, G. H., Linden, J. L. V. D., & Akkermans, W. (1997). Nominations,
#' Ratings, and the Dimensions of Sociometric Status. International Journal of
#' Behavioral Development, 21(1), 179-200. doi:10.1080/016502597385045\cr
#' Maassen, G. H., & Landsheer, J. A. (1998). SSRAT: The processing of rating
#' scales for the determination of two-dimensional sociometric status. Behavior
#' Research Methods Instruments & Computers, 30(4), 674-679.
#' @keywords package
NULL



