% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Mpplot.R
\name{Mpplot}
\alias{Mpplot}
\title{Traces of the space.}
\usage{
Mpplot(MpData)
}
\arguments{
\item{MpData}{object of class ConstructMPst.}
}
\value{
Graphic in three perspectives the space data "x", "y", "z" with divisions that containing the number of points in each quadrat.
}
\description{
Plot of three - dimensional perspective spatial, divides every window into quadrats defined for delta (see \code{\link{ConstructMPst}}) and counts the numbers of points in each quadrat.
}
\examples{
data(Metadb)
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")

MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))
Mpplot(MPST)
}

