% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConstructMPst.R
\name{ConstructMPst}
\alias{ConstructMPst}
\title{Construct Spatio - temporal regular data.}
\usage{
ConstructMPst(valuest,time,pts,Delta)
}
\arguments{
\item{valuest}{data.frame in which different columns refer to different locations, and each row reflects a particular observation time.}

\item{time}{indicate the time of valuest, the intervals of time must be regular.}

\item{pts}{data.frame that hold three dimensions spatial coordinates  \code{x},  \code{y} and  \code{z}. Therefore, the coordinates should be projected.}

\item{Delta}{vector with number of divisions of each spatial direction. c(Delta  \code{x}, Delta  \code{y}, Delta  \code{z}).}
}
\value{
An object of class ConstructMPst with the following list of components:

\item{results}{average value on the stations set into unity spatio -- temporal defined for delta.}

\item{Value}{array with the results organized by cells, the size of the cells is defined in Delta.}

\item{valuest}{valuest.}

\item{pts}{pts.}

\item{time}{time.}

\item{Delta}{Delta.}
}
\description{
Create an  spatio - temporal object with regular data, in order to employ median polish technique.
}
\details{
This function configures an irregular distribution of spatio -- temporal data in four - ways. Therefore, the new data corresponds to the average of values and coordinates of every spatio -temporal cell.
}
\examples{
## Not run:
library(zoo)
data(Metadb)
#records of monthly precipitation from january 2007 to january 2010
Metadb<-Metadb[,c(1:4,89:125)]
x<-matrix(0,1,37)
for(i in 1:37){
 x[,i] <- 2007 + (seq(0, 36)/12)[i]
}
x<-as.Date (as.yearmon(x), frac = 1)
time = as.POSIXct(x, tz = "GMT")
MPST<-ConstructMPst(Metadb[,-c(1:4)],time,pts=Metadb[,2:4],Delta=c(7,6,5))
## End(Not run)
}
\references{
Martínez, W. A., Melo, C. E., & Melo, O. O. (2017). \emph{Median Polish Kriging for space--time analysis of precipitation} Spatial Statistics, 19, 1-20. \href{http://www.sciencedirect.com/science/article/pii/S2211675316301336}{[link]}

Berke, O. (2001). \emph{Modified median polish kriging and its application to the wolfcamp - aquifer data.} Environmetrics, 12(8):731-748.\href{http://onlinelibrary.wiley.com/doi/10.1002/env.495/abstract}{[link]}
}
