% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{displayPlotSeries}
\alias{displayPlotSeries}
\title{Plot spatial series by selected columns}
\usage{
displayPlotSeries(dataset, rmotifs, position, space)
}
\arguments{
\item{dataset}{Dataset containing numeric values}

\item{rmotifs}{List of ranked motifs}

\item{position}{Select by an integer a motif with his position}

\item{space}{Select a range of columns to plot the corresponding spatial series}
}
\value{
Plot the spatial series
}
\description{
Plot a selected motif and range of columns of the dataset
}
\examples{
#Launch all the workflow
#Plot the result
D  <- STMotif::example_dataset
DS <- NormSAX(STMotif::example_dataset,7)
stmotifs <- SearchSTMotifs(D,DS,3,7,10,10,3,7)
rstmotifs <- RankSTMotifs(stmotifs)
displayPlotSeries(dataset = D, rmotifs = rstmotifs ,position = 1 ,space = c(1,2,5:7))
}
