% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf.R
\name{cdf}
\alias{cdf}
\title{Empirical Distribution Function of a Stressed Model}
\usage{
cdf(object, xCol = 1, wCol = 1)
}
\arguments{
\item{object}{A \code{SWIM} object.}

\item{xCol}{Numeric or character, (name of) the column of the underlying data 
of the \code{object} (\code{default = 1}).}

\item{wCol}{Numeric, the column of the scenario weights 
of the \code{object} (\code{default = 1}).}
}
\value{
The empirical distribution function (a function) of 
    the \code{xCol} component of the stressed model with weights 
    \code{wCol}. The empirical distribution function can be 
    evaluated at a vector.
}
\description{
Provides the empirical distribution function of a stressed 
    model component (random variable) under the scenario weights.
}
\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
grid <- seq(min(x$normal), max(x$normal), length.out = 5)
## stressed empirical distribution function
cdf(res1, xCol = 1, wCol = 1)(grid)
## baseline empirical distribution function
ecdf(x$normal)(grid)

}
\seealso{
See \code{\link{plot_cdf}} for plotting the empirical 
    distribution function of the stressed model and 
    \code{\link{quantile_stressed}} for sample quantiles of 
    a stressed model.
}
\author{
Silvana M. Pesenti
}
