% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{plot_summary}
\alias{plot_summary}
\alias{plot_summary.swmpr}
\title{Plot graphical summaries of SWMP data}
\usage{
plot_summary(swmpr_in, ...)

\method{plot_summary}{swmpr}(swmpr_in, param, years = NULL, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods, currently not used}

\item{param}{chr string of variable to plot}

\item{years}{numeric vector of starting and ending years to plot, default all}
}
\value{
A graphics object (Grob) of multiple \code{\link[ggplot2]{ggplot}} objects.
}
\description{
Plot graphical summaries of SWMP data for individual parameters, including seasonal/annual trends and anomalies
}
\details{
This function creates several graphics showing seasonal and annual trends for a given swmp parameter.  Plots include monthly distributions, monthly anomalies, and annual anomalies in multiple formats.  Anomalies are defined as the difference between the monthly or annual average from the grand mean.  Monthly anomalies are in relation to the grand mean for the same month across all years.  All data are aggregated for quicker plotting.  Nutrient data are based on monthly averages, wheras weather and water quality data are based on daily averages.  Cumulative precipitation data are based on the daily maximum.  An interactive Shiny widget is available: \url{https://beckmw.shinyapps.io/swmp_summary/}
}
\examples{
## import data
data(apacpnut)
dat <- qaqc(apacpnut)

## plot
plot_summary(dat, param = 'chla_n', years = c(2007, 2013))
}
\seealso{
\code{\link[ggplot2]{ggplot}}
}
\concept{
analyze

analyze
}

