% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\name{metab_day}
\alias{metab_day}
\title{Identify metabolic days in a swmpr time series}
\usage{
metab_day(dat_in, stat_in)
}
\arguments{
\item{dat_in}{data.frame}

\item{stat_in}{chr vector of station name including data type}
}
\description{
Identify metabolic days in a swmpr time series based on sunrise and sunset times for a location and date.  The metabolic day is considered the 24 hour period between sunsets for two adjacent calendar days.  The function calls the \code{\link[maptools]{sunriset}} function from the maptools package, which uses algorithms from the National Oceanic and Atmospheric Administration (\url{http://www.esrl.noaa.gov/gmd/grad/solcalc/}).
}
\details{
This function is only used within \code{\link{ecometab}} and should not be called explicitly.
}
\seealso{
\code{\link{ecometab}}, \code{\link[maptools]{sunriset}}
}

