% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{plot.swmpr}
\alias{plot.swmpr}
\alias{lines.swmpr}
\title{Plot swmpr data}
\usage{
\method{plot}{swmpr}(x, type = "l", ...)

\method{lines}{swmpr}(x, ...)
}
\arguments{
\item{x}{input swmpr object}

\item{type}{chr string for type of plot, default \code{'l'}.  See \code{\link[graphics]{plot}}.}

\item{...}{other arguments passed to \code{par}, \code{plot.default}}
}
\description{
Plot a time series of parameters in a swmpr object
}
\details{
The swmpr method for plotting is a convenience function for plotting a univariate time series.  Conventional plotting methods also work well since swmpr objects are also data frames.  See the examples for use with different methods.
}
\examples{
## get data
data(apadbwq)
swmp1 <- apadbwq

## subset
dat <- subset(swmp1, select = 'do_mgl', 
 subset = c('2013-07-01 00:00', '2013-07-31 00:00'))

## plot using swmpr method, note default line plot
plot(dat)

## plot using formula method
plot(do_mgl ~ datetimestamp, dat)

## plot using defualt, add lines
plot(dat, type = 'n')
lines(dat, col = 'red')
}
\seealso{
\code{\link[graphics]{plot}}
}
\concept{
analyze

analyze
}
