% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_circos_histogram.R
\name{write_circos_histogram}
\alias{write_circos_histogram}
\title{write_circos_histogram}
\usage{
write_circos_histogram(df, chromosome_grouping, start_position, end_position,
  values, file_name = "histogram.txt", file_path = NULL)
}
\arguments{
\item{df}{A database to draw Circos data from}

\item{chromosome_grouping}{A column defining the circos chromosomes. Passed as column index or "column name"}

\item{start_position}{A column defining the start positions of the desired value}

\item{end_position}{A column defining the end positions of the desired value}

\item{values}{The value to be plotted}

\item{file_name}{The desired file name. Defaults to histogram.txt}

\item{file_path}{The desired file path destination folder. Defaults to NULL}
}
\value{
Writes a Circos-compatible histogram file to the desired directory
}
\description{
A function that takes a data.frame, and creates a histogram.txt file for input into circos
}
\examples{

df <- data.frame(chrom = c(1,1,2,2), start = c(1, 5, 1, 8),
end = c(5, 10, 8, 13), plotting_value = c(5, 78, 9, 2))

write_circos_histogram(df = df, chromosome_grouping = "chrom",
start_position = "start", end_position = "end",
value = "plotting_value", file_name = "histogram.txt", file_path = tempdir())

}
\author{
Matthew Woodruff, Emory University
}
