% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compute.R
\encoding{UTF-8}
\name{compute}
\alias{compute}
\title{Aggregate a numeric variable}
\usage{
compute(formula, data = .data, FUN)
}
\arguments{
\item{formula}{The variable versus factor(s) to be computed (y~factor+factor).}

\item{data}{The data object.}

\item{FUN}{The function statistic to be calculated.}
}
\description{
Aggregate a numeric variable
}
\examples{
# data:
df=data.frame(group=sample(letters,100, TRUE),y=sample(100) )

#functions:
FUNS <- function(x) c(N=nrow(x), mean=round(mean(x),0),
sd=round(sd(x), 0), min=round(min(x),0),
max=round(max(x),0))

# Do the computation
compute(y~group, data=df, FUN=FUNS)
}

