% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rounded.R
\encoding{UTF-8}
\name{rounded}
\alias{rounded}
\title{Round Numbers Without Leading Zeros}
\usage{
rounded(x, digits = 2, add = FALSE, max = (digits + 2))
}
\arguments{
\item{x}{A numeric vector.}

\item{digits}{An integer for the number of digits to round to.}

\item{add}{Logical, whether additional digits are to be added if no number appears in the pre-set digit level, default is \code{FALSE}.}

\item{max}{The Maximum number of digits to be shown, only affects if \code{add=TRUE}.}
}
\value{
A vector of the same length of \code{x}, but stored as string.
}
\description{
Given a numeric vector, round numbers with no leading
zeros. Something nice for a plot or publicatio.
}
\examples{
x = seq(0, 1, by=.1)
rounded(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}

