% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet.R
\encoding{UTF-8}
\name{ddirichlet}
\alias{ddirichlet}
\title{Dirichlet Distribution}
\usage{
ddirichlet(x, alpha, log = FALSE, sum = FALSE)
}
\arguments{
\item{x}{a matrix containing observations.}

\item{alpha}{the Dirichlet distribution's parameters. Can be a vector (one set of parameters for all observations) or a matrix (a different set of parameters for each observation), see \dQuote{Details}.}

\item{log}{if \code{TRUE}, logarithmic densities are returned.}

\item{sum}{if \code{TRUE}, the (log-)likelihood is returned.}
}
\value{
the \code{ddirichlet} returns a vector of densities (if \code{sum = FALSE}) or the (log-)likelihood (if \code{sum = TRUE}) for the given data and alphas.
}
\description{
Density function and random number generation for the Dirichlet distribution
}
\examples{
mat <- cbind(1:10, 5, 10:1);
mat;
x <- rdirichlet(10, mat);

ddirichlet(x, mat);

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Distributions}

