% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_esd.R
\name{"sk_esd"}
\alias{"sk_esd"}
\alias{sk_esd}
\alias{SK.ESD}
\title{The Scott-Knott Effect Size Difference (ESD) Test}
\usage{
sk_esd(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{A wide-format data frame.}

\item{alpha}{The significance level.}

\item{...}{Optional parameters.}
}
\value{
A sk_esd object.
}
\description{
An enhancement of the Scott-Knott test (which cluster distributions into statistically distinct ranks) that takes effect size into consideration.
}
\examples{
sk <- sk_esd(example)
sk$original  # Original Groups
sk$groups    # Corrected Groups with effect size wise
sk$reverse   # Reversed Groups

# For a long-format data frame
long <- melt(example, id.vars=0)
data <- long2wide(long)
sk <- sk_esd(data) 

}
\author{
Chakkrit Tantithamthavorn (kla@chakkrit.com)
}
