% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDifference.R, R/sk_esd.R
\name{sk_esd}
\alias{sk_esd}
\alias{checkDifference}
\alias{sk_esd}
\alias{SK.ESD}
\title{A function to check the magnitude of the difference for all pairs of treatments}
\usage{
checkDifference(ranking, data)

sk_esd(x, alpha = 0.05, ...)
}
\arguments{
\item{ranking}{A ranking that is produced by the Scott-Knott ESD test}

\item{data}{a data frame of treatment means}

\item{x}{A wide-format data frame.}

\item{alpha}{The significance level.}

\item{...}{Optional parameters.}
}
\value{
A result of the magnitude of the difference for all pairs of treatments.

A sk_esd object.
}
\description{
A function to check the magnitude of the difference for all pairs of treatments

An enhancement of the Scott-Knott test (which cluster distributions into statistically distinct ranks) that takes effect size into consideration.
}
\examples{
sk <- sk_esd(example)
checkDifference(sk$groups, example)

sk <- sk_esd(example)
plot(sk)

sk <- sk_esd(maven)
plot(sk)

}
\author{
Chakkrit Tantithamthavorn (kla@chakkrit.com)
}
