% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/source_compete.R
\name{blm_bc}
\alias{blm_bc}
\title{Bayesian linear model with a Box-Cox transformation}
\usage{
blm_bc(
  y,
  X,
  X_test = X,
  psi = length(y),
  lambda = NULL,
  sample_lambda = TRUE,
  nsave = 1000,
  nburn = 1000,
  nskip = 0,
  verbose = TRUE
)
}
\arguments{
\item{y}{\code{n x 1} vector of observed counts}

\item{X}{\code{n x p} matrix of predictors}

\item{X_test}{\code{n_test x p} matrix of predictors for test data;
default is the observed covariates \code{X}}

\item{psi}{prior variance (g-prior)}

\item{lambda}{Box-Cox transformation; if NULL, estimate this parameter}

\item{sample_lambda}{logical; if TRUE, sample lambda, otherwise
use the fixed value of lambda above or the MLE (if lambda unspecified)}

\item{nsave}{number of MCMC iterations to save}

\item{nburn}{number of MCMC iterations to discard}

\item{nskip}{number of MCMC iterations to skip between saving iterations,
i.e., save every (nskip + 1)th draw}

\item{verbose}{logical; if TRUE, print time remaining}
}
\value{
a list with the following elements:
\itemize{
\item \code{coefficients} the posterior mean of the regression coefficients
\item \code{fitted.values} the posterior predictive mean at the test points \code{X_test}
\item \code{post_theta}: \code{nsave x p} samples from the posterior distribution
of the regression coefficients
\item \code{post_ypred}: \code{nsave x n_test} samples
from the posterior predictive distribution at test points \code{X_test}
\item \code{post_g}: \code{nsave} posterior samples of the transformation
evaluated at the unique \code{y} values
\item \code{post_lambda} \code{nsave} posterior samples of lambda
\item \code{post_sigma} \code{nsave} posterior samples of sigma
\item \code{model}: the model fit (here, \code{blm_bc})
}
as well as the arguments passed in.
}
\description{
MCMC sampling for Bayesian linear regression with a
(known or unknown) Box-Cox transformation. A g-prior is assumed
for the regression coefficients.
}
\details{
This function provides fully Bayesian inference for a
transformed linear model via MCMC sampling. The transformation is
parametric from the Box-Cox family, which has one parameter \code{lambda}.
That parameter may be fixed in advanced or learned from the data.
}
\note{
Box-Cox transformations may be useful in some cases, but
in general we recommend the nonparametric transformation (with
Monte Carlo, not MCMC sampling) in \code{\link{sblm}}.
}
\examples{
# Simulate some data:
dat = simulate_tlm(n = 100, p = 5, g_type = 'step')
y = dat$y; X = dat$X # training data
y_test = dat$y_test; X_test = dat$X_test # testing data

hist(y, breaks = 25) # marginal distribution

# Fit the Bayesian linear model with a Box-Cox transformation:
fit = blm_bc(y = y, X = X, X_test = X_test)
names(fit) # what is returned
round(quantile(fit$post_lambda), 3) # summary of unknown Box-Cox parameter

}
