% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diagnostics.R
\name{checkEventExposureIndependenceAssumption}
\alias{checkEventExposureIndependenceAssumption}
\title{Check diagnostic for event-dependent exposure}
\usage{
checkEventExposureIndependenceAssumption(sccsModel, nullBounds = c(0.8, 1.25))
}
\arguments{
\item{sccsModel}{A fitted SCCS model as created using \code{\link[=fitSccsModel]{fitSccsModel()}}.}

\item{nullBounds}{The bounds for the null hypothesis on the incidence rate ratio scale.}
}
\value{
A tibble with one row per pre-exposure window and four columns: \code{ratio} indicates the estimates
incidence rate ratio for the pre-exposure window. \code{lb} and \code{ub} represent the upper and lower
bounds of the 95 percent confidence interval, and \code{pass} is \code{TRUE} if the confidence interval
intersects the null bounds.
}
\description{
This diagnostic tests whether there is a dependency between the event and subsequent exposures.
This requires you have indicated one of the era covariates to be a pre-exposure window. This
function simply checks whether the confidence interval for the effect estimate of that pre-
exposure window overlaps with the \code{nullBounds}.

To designate an era covariate to be the pre-exposure window, set \code{preExposure = TRUE} when
calling \code{createEraCovariateSettings()}. Note that, by default, \code{preExposure} will be \code{TRUE} if
\code{start} is smaller than 0.
}
