% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotEventObservationDependence}
\alias{plotEventObservationDependence}
\title{Plot time from event to observation end for censored and uncensored time.}
\usage{
plotEventObservationDependence(studyPopulation, title = NULL, fileName = NULL)
}
\arguments{
\item{studyPopulation}{An object created using the \code{\link[=createStudyPopulation]{createStudyPopulation()}} function.}

\item{title}{Optional: the main title for the plot}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'.
See the function \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for supported file formats.}
}
\value{
A ggplot object. Use the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function to save to file in a different
format.
}
\description{
Plot time from event to observation end for censored and uncensored time.
}
\details{
This plot shows whether there is a difference in time between (first) event and the observation period end for periods that are '
censored' and those that are 'uncensored'. By 'censored' we mean periods that end before we would normally expect. Here, we define
periods to be uncensored if they end at either the study end date (if specified), database end date (i.e. the date after which no
data is captured in the database), or maximum age (if specified). All other periods are assumed to be censored.

As proposed by Farrington et al., by comparing the two plots, we can gain some insight into whether the censoring is dependent
on the occurrence of the event.
}
\references{
Farrington P, Whitaker H, Ghebremichael Weldeselassie Y (2018), Self-controlled case series studies: A modelling guide with R, Taylor &
Francis
}
