% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScriDataConversion.R
\name{createScriIntervalData}
\alias{createScriIntervalData}
\title{Create Self-Controlled Risk Interval (SCRI) era data}
\usage{
createScriIntervalData(studyPopulation, sccsData, createScriIntervalDataArgs)
}
\arguments{
\item{studyPopulation}{An object created using the \code{\link[=createStudyPopulation]{createStudyPopulation()}} function.}

\item{sccsData}{An object of type \link{SccsData} as created using the
\link{getDbSccsData} function.}

\item{createScriIntervalDataArgs}{An object of type \code{CreateScriIntervalDataArgs} as created by
the \code{createCreateScriIntervalDataArgs()} function.}
}
\value{
An object of type \link{SccsIntervalData}.
}
\description{
Create Self-Controlled Risk Interval (SCRI) era data
}
\details{
This function creates interval data according to the elf-Controlled Risk Interval (SCRI) design.
Unlike the generic SCCS design, where all patient time is used to establish a background rate,
in the SCRI design a specific control interval (relative to the exposure) needs to be defined.
The final model will only include time that is either part of the risk interval (defined using
the \code{eraCovariateSettings} argument, or the control interval (defined using \code{controlIntervalSettings}).
}
\references{
Greene SK, Kulldorff M, Lewis EM, Li R, Yin R, Weintraub ES, Fireman BH, Lieu TA, Nordin JD,
Glanz JM, Baxter R, Jacobsen SJ, Broder KR, Lee GM. Near real-time surveillance for influenza
vaccine safety: proof-of-concept in the Vaccine Safety Datalink Project. Am J Epidemiol. 2010
Jan 15;171(2):177-88. doi: 10.1093/aje/kwp345.
}
