% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2cytoscape.R
\name{convert2cytoscape}
\alias{convert2cytoscape}
\title{Convert Adjacency Matrix to Cytoscape Format}
\usage{
convert2cytoscape(A)
}
\arguments{
\item{A}{Matrix or data frame.
A cleaned, finalized response matrix ready to be visualized}
}
\value{
A sparse matrix formatted for Cytoscape
}
\description{
Converts an adjacency matrix to Cytoscape's sparse matrix format
}
\examples{
# Simulate Datasets
one <- sim.fluency(10)
two <- sim.fluency(10)

# Compute similarity matrix
cos1 <- similarity(one, method = "cosine")
cos2 <- similarity(two, method = "cosine")

# Compute networks
net1 <- TMFG(cos1)
net2 <- TMFG(cos2)

# Convert to Cytoscape format
cyto1 <- convert2cytoscape(net1)
cyto2 <- convert2cytoscape(net2)

# Write to .csv
write.csv(cyto1, file.path(tempdir(), "cyto1.csv"), row.names = FALSE)
write.csv(cyto2, file.path(tempdir(), "cyto2.csv"), row.names = FALSE)

}
\references{
Shannon, P., Markiel, A., Ozier, O., Baliga, N. S., Wang, J. T., Ramage, D., ... & Ideker, T. (2003).
Cytoscape: A software environment for integrated models of biomolecular interaction networks.
\emph{Genome Research}, \emph{13}, 2498-2504.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
