% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemanticNetworkCleaner.R
\name{destr}
\alias{destr}
\title{De-string Responses}
\usage{
destr(rmat, rm.str)
}
\arguments{
\item{rmat}{A semnetcleaner filtered response matrix}

\item{rm.str}{The column number of the stringed response}
}
\value{
The response matrix with the string column merged into appropriate response columns and the string response removed
}
\description{
De-string responses after performing semnetcleaner
}
\examples{
#create example stringed responses
stringed <- cbind(rowSums(cbind(rmat[,c(1,2)])),convmat)
#change name to stringed name
colnames(stringed)[1] <- "alligator.ant"

#de-string
convmat <- destr(stringed, 1)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
