% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{numNegativeEntries}
\alias{numNegativeEntries}
\title{Number of negative words in dictionary}
\usage{
numNegativeEntries(d)
}
\arguments{
\item{d}{is a dictionary of type \code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}}
}
\description{
Counts total number of negative entries in dictionary.
}
\note{
Entries in \code{\link{SentimentDictionaryWeighted}} with a weight of 0 
are not counted here
}
\examples{
numNegativeEntries(SentimentDictionary(c("increase", "rise", "more"),
                            c("fall", "drop"))) # returns 2
numNegativeEntries(SentimentDictionary(c("increase", "decrease", "exit"),
                               c(+1, -1, -10),
                               rep(NA, 3))) # returns 2
}
\seealso{
\code{\link{numEntries}} and 
\code{\link{numPositiveEntries}} for more option to count the number of entries
}
\keyword{dictionary}
