% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessCorpus.R
\name{preprocessCorpus}
\alias{preprocessCorpus}
\title{Default preprocessing of corpus}
\usage{
preprocessCorpus(
  corpus,
  language = "english",
  stemming = TRUE,
  verbose = FALSE,
  removeStopwords = TRUE
)
}
\arguments{
\item{corpus}{\code{\link[tm]{Corpus}} object which should be processed}

\item{language}{Default language used for preprocessing (i.e. stop word removal and stemming)}

\item{stemming}{Perform stemming (default: TRUE)}

\item{verbose}{Print preprocessing status information}

\item{removeStopwords}{Flag indicating whether to remove stopwords or not (default: yes)}
}
\value{
Object of \code{\link[tm]{Corpus}}
}
\description{
Preprocess existing corpus of type \code{\link[tm]{Corpus}} according to default operations. 
This helper function groups all standard preprocessing steps such that the usage of the 
package is more convenient.
}
\keyword{corpus}
\keyword{preprocessing}
