\name{FRSC}
\alias{FRSC}
\docType{data}
\title{Freitag and Schlicht (2009)}
\description{The \code{FRSC} data frame has 16 rows and 8 variables}
\usage{data(FRSC)}
\format{
  A data frame with 16 observations on the following 8 variables.
  \describe{
    \item{\code{integrated_comp_schools}}{a numeric vector. Condition, percentage  of Pupils Enrolled in Integrated Comprehensive Schools,}
    \item{\code{coop_comp_schools}}{a numeric vector. Condition, percentage  of Pupils Enrolled in Cooperative Comprehensive Schools.}
    \item{\code{full_day_schools}}{a numeric vector. Condition, percentage of Pupils Enrolled in All-Day Schools}
    \item{\code{child_care}}{a numeric vector. Condition, ratio of Number of Child Care Facilities to Total Population between 0 and 6 Years (percent).}
    \item{\code{pre_schools}}{a numeric vector. Condition, ratio of pupils Enrolled in Pre-School to Total 6-Year-Old Population (per cent)}
    \item{\code{early_tracking}}{a numeric vector. Condition, onset of Tracking, Legal Regulation.}
    \item{\code{outcome}}{a numeric vector. Outcome, high Degree of Social Inequality
Cases in Education. }
    \item{\code{indep_hauptschule}}{a numeric vector. Condition, autonomy of the Hauptschule.}
  }
}
\details{
Data are used by Freitag and Schlicht (2009) to analyze social inequality in education. The data are raw scores.}
%\source{}
\references{Freitag, M, and Schlicht, R. (2009) "Educational Federalism in Germany: Foundations of Social Inequalities in Education", Governance 22(1), pp. 47-72.

Schneider, C. Q., Wagemann, C. (2012) Set-Theoretic Methods for the Social Sciences, Cambridge University Press: Cambridge.

Schneider, C. Q., Wagemann, C., Quaranta, M. (2012) How To... Use Software for Set-Theoretic Analysis. Online Appendix to "Set-Theoretic Methods for the Social Sciences". Available at \url{www.cambridge.org/schneider-wagemann}}
\examples{data(FRSC)}
\keyword{datasets}
