% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{FindAllMarkersNode}
\alias{FindAllMarkersNode}
\title{Find all markers for a node}
\usage{
FindAllMarkersNode(object, node = NULL, genes.use = NULL,
  logfc.threshold = 0.25, test.use = "wilcox", min.pct = 0.1,
  min.diff.pct = 0.05, print.bar = TRUE, only.pos = FALSE,
  max.cells.per.ident = Inf, return.thresh = 0.01, do.print = FALSE,
  random.seed = 1, min.cells.gene = 3, min.cells.group = 3,
  assay.type = "RNA", ...)
}
\arguments{
\item{object}{Seurat object. Must have object@cluster.tree slot filled. Use BuildClusterTree() if not.}

\item{node}{Node from which to start identifying split markers, default is top node.}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{logfc.threshold}{Limit testing to genes which show, on average, at least
X-fold difference (log-scale) between the two groups of cells.}

\item{test.use}{Denotes which test to use. Seurat currently implements
"bimod" (likelihood-ratio test for single cell gene expression, McDavid et
al., Bioinformatics, 2013, default), "roc" (standard AUC classifier), "t"
(Students t-test), and "tobit" (Tobit-test for differential gene expression,
as in Trapnell et al., Nature Biotech, 2014), 'poisson', and 'negbinom'.
The latter two options should only be used on UMI datasets, and assume an underlying
poisson or negative-binomial distribution.}

\item{min.pct}{- only test genes that are detected in a minimum fraction of min.pct cells
in either of the two populations. Meant to speed up the function by not testing genes that are very infrequently expression}

\item{min.diff.pct}{- only test genes that show a minimum difference in the fraction of detection between the two groups. Set to -Inf by default}

\item{print.bar}{Print a progress bar once expression testing begins (uses pbapply to do this)}

\item{only.pos}{Only return positive markers (FALSE by default)}

\item{max.cells.per.ident}{Down sample each identity class to a max number. Default is no downsampling.}

\item{return.thresh}{Only return markers that have a p-value < return.thresh, or a power > return.thresh (if the test is ROC)}

\item{do.print}{Print status updates}

\item{random.seed}{Random seed for downsampling}

\item{min.cells.gene}{Minimum number of cells expressing the gene in at least one
of the two groups, currently only used for poisson and negative binomial tests}

\item{min.cells.group}{Minimum number of cells in one of the groups}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}

\item{\dots}{Additional parameters to pass to specific DE functions}
}
\value{
Returns a dataframe with a ranked list of putative markers for each node and associated statistics
}
\description{
This function finds markers for all splits at or below the specified node
}
\examples{
pbmc_small

FindAllMarkersNode(pbmc_small)

}
