% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{PrintICA}
\alias{PrintICA}
\title{Print the results of a ICA analysis}
\usage{
PrintICA(object, ics.print = 1:5, genes.print = 30, use.full = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{ics.print}{Set of ICs to print genes for}

\item{genes.print}{Number of genes to print for each PC}

\item{use.full}{Use full PCA (i.e. the projected PCA, by default FALSE)}
}
\value{
Only text output
}
\description{
Prints a set of genes that most strongly define a set of independent components
}
\examples{
pbmc_small
pbmc_small <- RunICA(object = pbmc_small, ics.compute = 10, ics.print = 0)
pbmc_small <- ProjectDim(object = pbmc_small, reduction.type = "ica", do.print = FALSE)
PrintICA(object = pbmc_small)
# Options for how many dimensions and how many genes to print
PrintICA(object = pbmc_small, ics.print = 1:2, genes.print = 5)
# Can also print for the projected PCA
PrintICA(object = pbmc_small, use.full = TRUE)

}
