% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\docType{methods}
\name{AddMetaData}
\alias{AddMetaData}
\alias{SeuratAccess}
\alias{AddMetaData.Assay}
\alias{AddMetaData.Seurat}
\alias{[[<-,Assay-method}
\alias{[[<-,Seurat-method}
\title{Add in metadata associated with either cells or features.}
\usage{
AddMetaData(object, metadata, col.name = NULL)

\method{AddMetaData}{Assay}(object, metadata, col.name = NULL)

\method{AddMetaData}{Seurat}(object, metadata, col.name = NULL)

\S4method{[[}{Assay}(x, i, j, ...) <- value

\S4method{[[}{Seurat}(x, i, j, ...) <- value
}
\arguments{
\item{x, object}{An object}

\item{i, col.name}{Name to store metadata or object as}

\item{j}{Ignored}

\item{...}{Arguments passed to other methods}

\item{value, metadata}{Metadata or object to add}
}
\value{
An object with metadata or and object added
}
\description{
Adds additional data to the object. Can be any piece of information
associated with a cell (examples include read depth, alignment rate,
experimental batch, or subpopulation identity) or feature (ENSG name,
variance). To add cell level information, add to the Seurat object. If adding
feature-level metadata, add to the Assay object (e.g. object[["RNA"]]))
}
\examples{
cluster_letters <- LETTERS[Idents(object = pbmc_small)]
names(cluster_letters) <- colnames(x = pbmc_small)
pbmc_small <- AddMetaData(
  object = pbmc_small,
  metadata = cluster_letters,
  col.name = 'letter.idents'
)
head(x = pbmc_small[[]])

}
