% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CombinePlots}
\alias{CombinePlots}
\title{Combine ggplot2-based plots into a single plot}
\usage{
CombinePlots(plots, ncol = NULL, legend = NULL, ...)
}
\arguments{
\item{plots}{A list of gg objects}

\item{ncol}{Number of columns}

\item{legend}{Combine legends into a single legend
choose from 'right' or 'bottom'; pass 'none' to remove legends, or \code{NULL}
to leave legends as they are}

\item{...}{Extra parameters passed to plot_grid}
}
\value{
A combined plot
}
\description{
Combine ggplot2-based plots into a single plot
}
\examples{
pbmc_small[['group']] <- sample(
  x = c('g1', 'g2'),
  size = ncol(x = pbmc_small),
  replace = TRUE
)
plot1 <- FeaturePlot(
  object = pbmc_small,
  features = 'MS4A1',
  split.by = 'group'
)
plot2 <- FeaturePlot(
  object = pbmc_small,
  features = 'FCN1',
  split.by = 'group'
)
CombinePlots(
  plots = list(plot1, plot2),
  legend = 'none',
  nrow = length(x = unique(x = pbmc_small[['group', drop = TRUE]]))
)

}
