% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{HoverLocator}
\alias{HoverLocator}
\title{Hover Locator}
\usage{
HoverLocator(plot, information = NULL, axes = TRUE, dark.theme = FALSE, ...)
}
\arguments{
\item{plot}{A ggplot2 plot}

\item{information}{An optional dataframe or matrix of extra information to be displayed on hover}

\item{axes}{Display or hide x- and y-axes}

\item{dark.theme}{Plot using a dark theme?}

\item{...}{Extra parameters to be passed to \code{\link[plotly]{layout}}}
}
\description{
Get quick information from a scatterplot by hovering over points
}
\examples{
\dontrun{
plot <- DimPlot(object = pbmc_small)
HoverLocator(plot = plot, information = FetchData(object = pbmc_small, vars = 'percent.mito'))
}

}
\seealso{
\code{\link[plotly]{layout}} \code{\link[ggplot2]{ggplot_build}}
\code{\link{DimPlot}} \code{\link{FeaturePlot}}
}
