% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{[.Seurat}
\alias{[.Seurat}
\alias{subset.Seurat}
\alias{subset}
\title{Subset a Seurat object}
\usage{
\method{[}{Seurat}(x, i, j, ...)

\method{subset}{Seurat}(x, subset, cells = NULL, features = NULL, idents = NULL, ...)
}
\arguments{
\item{x}{Seurat object to be subsetted}

\item{i, features}{A vector of features to keep}

\item{j, cells}{A vector of cells to keep}

\item{...}{Extra parameters passed to \code{\link{WhichCells}},
such as \code{slot}, \code{invert}, or \code{downsample}}

\item{subset}{Logical expression indicating features/variables to keep}

\item{idents}{A vector of identity classes to keep}
}
\value{
A subsetted Seurat object
}
\description{
Subset a Seurat object
}
\examples{
pbmc_small[VariableFeatures(object = pbmc_small), ]
pbmc_small[, 1:10]

subset(x = pbmc_small, subset = MS4A1 > 4)
subset(x = pbmc_small, subset = `DLGAP1-AS1` > 2)
subset(x = pbmc_small, idents = '0', invert = TRUE)
subset(x = pbmc_small, subset = MS4A1 > 3, slot = 'counts')
subset(x = pbmc_small, features = VariableFeatures(object = pbmc_small))

}
\seealso{
\code{\link[base]{subset}} \code{\link{WhichCells}}
}
